<?php

namespace VM\ApiBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;

class EstatesController extends AbstractController
{
    /**
     * @View(serializerGroups={"simpleList"})
     */
    public function getEstatesAction()
    {
        $User = $this->getUser();
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);

        $response = array();
        $estates = $Company->getPlaces();

        foreach($estates as $CompanyAllegroCattegoryItem)
        {
            if(!isset($response[$CompanyAllegroCattegoryItem->getItem()->getId()]))
            {
                $response[$CompanyAllegroCattegoryItem->getItem()->getId()] = array(
                    'item' => $CompanyAllegroCattegoryItem->getItem(),
                    'list' => array()
                );
            }

            $response[$CompanyAllegroCattegoryItem->getItem()->getId()]['list'][] = $CompanyAllegroCattegoryItem;
        }

        return array_values($response);
    }

    /**
     * @View(serializerGroups={"simpleList"})
     */
    public function buyEstateAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $Round = $this->getApiGetter()->getUserActualRound($User);

            $data = $this->getRequest()->request->getIterator()->getArrayCopy();
            $Item = $this->getApiGetter()->getAllegroItem($data['item_id']);


            if($data['id'] == 0)
            {
                $CompanyAllegroCategoryItem = new CompanyAllegroCategoryItem();
                $CompanyAllegroCategoryItem->setCompany($Company);
                $CompanyAllegroCategoryItem->setItem($Item);
                $CompanyAllegroCategoryItem->setRound($Round);
                $CompanyAllegroCategoryItem->setPrice($Item->getBuyNowPrice());
                $CompanyAllegroCategoryItem->setQuantity(1);

                $this->getDoctrine()->getManager()->persist($CompanyAllegroCategoryItem);
            }
            else
            {
                throw new \Exception('Estate exists');                
            }

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();


            $companyAllegroCategoryItemId = $CompanyAllegroCategoryItem->getId();
            $this->getDoctrine()->getManager()->clear();


            if(!empty($companyAllegroCategoryItemId))
            {
                $CompanyAllegroCategoryItem = $this->getApiGetter()->getCompanyAllegroItem($companyAllegroCategoryItemId);

                return $CompanyAllegroCategoryItem;
            }
            else
            {
                return true;
            }
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            //return array('error' => $Exception->getMessage());
            return false;
        }
    }

    /**
     * @View(serializerGroups={"simpleList"})
     */
    public function removeEstateAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $Round = $this->getApiGetter()->getUserActualRound($User);

            $data = $this->getRequest()->request->getIterator()->getArrayCopy();
            $Item = $this->getApiGetter()->getAllegroItem($data['item_id']);

            if(!$data['id'])
            {
                throw new \Exception('No estate id');                
            }

            $CompanyAllegroCategoryItem = $this->getApiGetter()->getCompanyAllegroItem($data['id']);

            $this->getDoctrine()->getManager()->remove($CompanyAllegroCategoryItem);
            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();
            
            return true;

        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            return false;
        }
    }
}
